// Mark Sowul 2002
//All rights reserved

//Mark Sowul Per. 6
#include <iostream> 
using namespace std;
#include <stdlib.h>

#include "apstring.h"

#include "card.h"
#include "deck.h"
#include "hand.h"



void display(hand player, hand dealer, int cash, int bet); //displays your cards + first dealer card + money
void displayAll(hand player, hand dealer); //displays full hands
int max(int first, int second); //returns greater of 2 values
char toCaps(char); //letter to caps
int winlose(hand player, hand dealer, int reasoncode, int bet, int i); //handles win/lose display and handles bet return
																//only matters when split (for display purposes)
char getOption(bool canDouble, bool canSplit, bool gettingSplit); //returns option
//codes:
//	0=player blackjack, 1=dealer blackjack, 2=bust, 3=lose, 4=win, 5=dealer bust, 6=push

void main()
{	//setups
	deck theDeck;
	int cash=100, bet;
	char toDo;
	cout << "Mark's Master Blackjack" << "\n\n";
	for(int count=0; cash>0; count++)
	{//while we have money 
		if (count > 9)
		{
			theDeck.shuffle();
			count=1;
		}

		//more things that need to be reset each hand
		hand player(0, theDeck.getCard(), theDeck.getCard()), dealer(1, theDeck.getCard(), theDeck.getCard());
		bool canDouble=true, canSplit=true, done=false, insured=false;
		apvector<bool> madeUpMind(2, false);	
									//for splitting, makes sure both hands are finished before displaying outcome		
		do{	//get valid bet
			cout << "Enter bet ( must be less than " << cash << " ): ";
			cin >> bet;
			cin.ignore();
		}while(bet<=0 || bet>cash || bet>1048576);
		cash-=bet;
				
		if (bet > cash)
		{	//double/split logic
			canDouble=false;
			canSplit=false;
		}

		if (player.getCard(0).getValue()!=player.getCard(1).getValue())
			canSplit=false; //split logic

		display(player, dealer, cash, bet); //display hands + bet
		
		if(dealer.getCard(0).getValue()==11)
		{
			if(!(cash<bet/2))
			{
				cout << "Would you like insurance against a dealer blackjack (Y/N)?\n";
				apstring temp;
				do
				{
					cin >> temp;
					toDo=toCaps(temp[0]);
				}while (toDo!='Y' && toDo!='N');
				if (toDo=='Y')
				{
					insured=true;
					cash-=(bet/2);
				}
			}
		}

		if (dealer.totalValue(0)==21 && !(player.totalValue(0)==21))
		{//handle dealer blackjack
			if(insured)
				cash+=winlose(player, dealer, 6, bet, 0);
			else
				cash+=winlose(player, dealer, 1, bet, 0);
			continue;
		}

		if (dealer.totalValue(0)==21)
		{//both have blackjack
			if(!insured)
				cash+=winlose(player, dealer, 6, bet, 0);
			else
				cash+=winlose(player, dealer, 4, bet, 0);
			continue;
		}

		if (player.totalValue(0)==21)
		{//handle player blackjack
			cash+=winlose(player, dealer, 0, bet, 0);
			continue;
		}
		
		while(dealer.totalValue(0) <= 16) //dealer hit until > 16
			dealer.addCard(theDeck.getCard());

		for (int i=0; i <= player.amISplit(); i++)
		{//runs twice if split once if not
			if (madeUpMind[i] && !madeUpMind[!i])
				continue; //if hand is decided but not split then get split
			
			toDo=getOption(canDouble, canSplit, i); //get valid choice
			
			switch(toDo)
			{//take action based on choice
			case('H'):
				if(!i)
					player.addCard(theDeck.getCard());
				else
					player.addSplitCard(theDeck.getCard());
				canDouble=false;
				break; //add a card
			case('D'):
				cash-=bet;
				bet*=2; //double bet and add card
				player.addCard(theDeck.getCard());
				break;
			case('P'):
				cash-=bet;
				bet*=2; //split the hand
				player.split(theDeck.getCard(), theDeck.getCard());
				display(player, dealer, cash, bet);
				canSplit=false;
				canDouble=false;
				i=-1; //so we start again with non split portion of hand
				continue; //restart loop
			}
			
			if (player.totalValue(0) > 21)
			{//player busts
				if (player.amISplit())
				{
					display(player, dealer, cash, bet);
					madeUpMind[i]=true; //ends this portion if split
					continue;
				}
				else
				{ //otherwise instant lose
					cash+=winlose(player, dealer, 2, bet, 0);
					count++;
					break;
				}
			}
			
			if (toDo=='H') //hit
			{ //restart loop if hit
				display(player, dealer, cash, bet);
				i--; //so that we continue with same hand (not move to split)
				continue;
			}
			
			if(toDo=='S' || toDo=='D')
			{//final stand or double
				madeUpMind[i]=true;
				if (!player.amISplit() || (madeUpMind[0] && madeUpMind[1]))
				{//make sure either not split or both hand and split are decided
					for (int j=0; j <= player.amISplit(); j++)
					{//display outcome for hand and split (if exist...this is handled in winlose)
						if(player.totalValue(j) > dealer.totalValue(0) && dealer.totalValue(0) <= 21)
						{
							cash+=winlose(player, dealer, 4, bet, j); //player wins
							done=true;
						}
						if (player.totalValue(j) < dealer.totalValue(0) && dealer.totalValue(0) <= 21)
						{
							cash+=winlose(player, dealer, 3, bet, j); //dealer wins
							done=true;
						}
						if (dealer.totalValue(0) > 21 && player.totalValue(j) <= 21)
						{
							cash+=winlose(player, dealer, 5, bet, j); //dealer busts
							done=true;
						}
						if (player.totalValue(j) == dealer.totalValue(0) && player.totalValue(0) <= 21)
						{
							cash+=winlose(player, dealer, 6, bet, j); //push
							done=true;
						}
						if (!done)
						{
							cerr << "Unhandled case... Player Value: " << player.totalValue(0) << "  Dealer Value: " << dealer.totalValue(0);
							return;
						}
					}
				}
			}
		}
	}
	cout << "Aw, you lose...";
	system("PAUSE");
}


void display(hand player, hand dealer, int cash, int bet)
{
#ifndef _DEBUG
	system("CLS"); //clear screen
#endif
	cout << "Player holds:\t\t\tDealer holds:\n"; //heading
		for (int i=0; i<player.howManyCards(); i++) //go through for number of cards
			cout << player.getCardString(i) << dealer.getCardStringMasked(i) << '\n';
	cout << '\n' << "(Value: " << player.totalValue(0);  //out total value of hand
	if (player.amISplit())  //out total value of split
		cout << ")\n(Split Value: " << player.totalValue(1);
	 cout << ") \n\nYour cash: " << cash << "\tYour current bet: " << bet << "\n\n";
}

void displayAll(hand player, hand dealer)
{
	cout << "Player holds:\t\t\tDealer holds:\n"; //begin same as above
		for (int i=0; i< max(max(player.howManySplit(), player.howManyCards()), dealer.howManyCards()); i++)
			cout << player.getCardString(i) << dealer.getCardString(i) << '\n'; //need to get all cards of hand, split & dealer
	cout << '\n' << "(Value: " << player.totalValue(0) << ") \t\t\t(Value: " << dealer.totalValue(0);
	if (player.amISplit())
		cout << ")\n(Split Value: " << player.totalValue(1);
	 cout << ") \n\n";
}

char toCaps(char letter)
{ //simple function for UCASE(char)
	if (letter >= 97)
		return letter-32;
	return letter;
}

int winlose(hand player, hand dealer, int code, int bet, int i)
{//handle win/lose display and calc money to be added to player's cash (if any)
	if (player.amISplit())
		bet/=2;
	int tempMoney=0; //default
	apstring tempString; //what we output at end
#ifndef _DEBUG
	cin.ignore(0, '\n'); //for cls
#endif
	if (!i)
	{//if no split or first part of split
#ifndef _DEBUG
		system("CLS"); //cls and display full hand
#endif
		displayAll(player, dealer);
	}
	if (i) //depending on which iteration of loop we're in
		cout << "Split results: ";
	else
		cout << "Hand results: ";
	switch(code)
	{//reason code
	case(0):
		tempString = "BlackJack! You win!";
		tempMoney=(bet*3)/2;
		break;
	case(1):
		tempString = "Dealer BlackJack! You lose!";
		break;
	case(2):
		tempString = "You busted! You lose!";
		break;
	case(3):
		tempString = "You lose!";
		break;
	case(4):
		tempString = "You win!";
		tempMoney=2*bet;
		break;
	case(5):
		tempString = "Dealer busted! You win!";
		tempMoney=2*bet;
		break;
	case(6):
		tempString = "Push! Tie!";
		tempMoney=bet;
		break;
	}
	cout << tempString << '\n';
	if (i || !player.amISplit())
		cout << '\n'; //pretty our string with newlines
	return tempMoney; //amount to add to bet
}

int max(int first, int second)
{ //simple function for getting larger of 2 numbers
	if (first < second)
		return second;
	return first;
}

char getOption(bool canDouble, bool canSplit, bool gettingSplit)
{
		char toDo;
		apstring tempToDo;
		if (gettingSplit)
			cout << "Split ";
		else
			cout << "Hand ";
		do{
				cout << "Options:\n<H>it\n<S>tand\n";
			if (canDouble)
				cout << "<D>ouble\n";
			if (canSplit)
				cout << "S<p>lit\n";
			cout << "Enter Choice: ";
			getline(cin, tempToDo);
			if(!tempToDo.length())
				continue;
			toDo=toCaps(tempToDo[0]);
			cout << '\n';
			toDo=toCaps(toDo);
		}while((toDo!='H' && toDo!='S' && toDo!='D' && toDo!='P') || (toDo=='D' && !canDouble) || (toDo=='P' && !canSplit));
	return toDo;
}
